'''
demo -- Simple demo for FLASH-log analyzer
Author: duvall@wustl.edu
'''

# init
print('\nInitializing FlashLogs...')
from flashlogs import *
bIsWindows = os.name == 'nt'
os.chdir(os.path.dirname( os.path.realpath(__file__) ))
bInteractive = __name__ != '__main__'
plt.interactive(bInteractive)

# analyze
FILE = 'MevionFLASH_05152024_152107_demo.log'
la = LogAnalyzer(FILE)

# print an example delivery record
DRN = 0
print('Example Delivery Record\n###')
dr = la.get_delivery_record(DRN)
dr.info()
print('\n')
print('Detailed parameter list:\n')
dr.print_params()
print('\n')

# prepare some plot vars
df = dr.pulses
xvar = df.Timestamp_uS.name
yvar = df.Doseplane_pC.name

# plot distribution of number of pulses per delivery record
pulses_per_record = np.array( [len(pulse_df) for pulse_df in la.all_pulse_records] )
print('Plotting distribution of pulses per delivery record...')
f_np = plt.subplots()[0]
h0 = plt.hist( pulses_per_record )
plt.title('Pulses per Delivery Record')
plt.xlabel('Number of Pulses')
# if bInteractive: plt.show()
if bInteractive:
    plt.show()
else:
    if bIsWindows:
        plt.close()
print('Done.\n')

# demo distribution across all delivery records for a selected pulse-data column at a selected PulseCount
print('Creating demo distribution...')
DF = la.combined_pulse_records
DF1 = DF[ DF.PulseCount == 0 ]
N = DF1.shape[0] 
nbins = int( np.round( 2 * np.sqrt(N) ) )
h = DF1.hist( bins = nbins, column = yvar )
plt.gca().set_title(f'Distribution for [PulseCount == 0] (N={N})')
plt.xlabel(yvar)
f_hist = plt.gcf()
# if bInteractive: plt.show()
if bInteractive:
    plt.show()
else:
    if bIsWindows:
        plt.close()
print('Done.\n')

# demo plot and results for single delivery record
print('Creating demo plot...')
la.show_next_record()
f_xy = la.record_figure
# if bInteractive: plt.show()
if bInteractive:
    plt.show()
else:
    if bIsWindows:
        plt.close()
print('Done.\n')

# full profile
print('Creating profile...')
f_prof = la.profile()
# if bInteractive: plt.show()
if bInteractive:
    plt.show()
else:
    if bIsWindows:
        plt.close()
print('Done.\n')

# check whether to save plots
bSave = False
if bInteractive:
    save_response = input('Save figures? [y/N]  ').strip().lower()
    if 'n' not in save_response and re.search('y[es]?', save_response):
        bSave = True
else:
    bSave = True

# save plots if desired
if bSave:
    print('Saving plots...')
    f_np.savefig('demo_rl.png')
    f_xy.savefig('demo_xy.png')
    f_hist.savefig('demo_hist.png')
    f_prof.savefig('demo_prof.png')
    print('Done.')

# all pau!   )
print('\n\nDemo complete!\n\n')

